<?php 
/**
 * 归档
 * 
 * @package custom 
 * 
 */
if (!defined('__TYPECHO_ROOT_DIR__')) exit;
$this->need('header.php');
$stat = Typecho_Widget::widget('Widget_Stat');
?>

<div class="grid grid-cols-2 md:grid-cols-4 gap-4 text-white mb-5 lg:mb-6">

<?php 
$tongji=[
[
'文章统计',
$stat->publishedPostsNum,
'篇文章',
' bg-[#c98c9a] ',
'🎐',
],
[
'分类统计',
$stat->categoriesNum,
'个分类',
' bg-[#4fb19d] ',
'🏜️',
],
[
'评论统计',
$stat->PublishedCommentsNum,
'条评论',
' bg-[#edce7a] ',
'🏖️',
],
[
'标签统计',
$stat->tagsNum,
'条标签',
' bg-[#9ac5e5] ',
'🏝️',
],
];

foreach($tongji as $tongji){
?>
<div class="flex flex-col shadow <?php echo  $tongji[3];?> h-28 p-4 rounded-lg bg-no-repeat bg-right-bottom" style=" background-image: url(<?php echo $this->options->themeUrl('img/circle.svg');?>); ">
                <div class="flex flex-col flex-1">
                <div class="flex-1 flex justify-between"><span><?php echo  $tongji[0];?></span><span><?php echo  $tongji[4];?></span></div>
                <div class="text-xl md:text-2xl italic">
                <div>    
                <span x-data="{ shown: false }" x-intersect="shown = true" :class="{'ani-num':shown}" style="--num: <?php echo  $tongji[1];?>"><?php echo  $tongji[1];?></span><?php echo  $tongji[2];?></div>
                </div>
                </div>
</div>

<?php
}
?>
</div>



<?php $archives = archives($this); $index = 0; foreach ($archives as $year => $posts): ?>

<div class="rounded-lg bg-white dark:bg-gray-900 shadow mb-5" x-data="{faq:<?php if($index<=2){echo 'true';}else{echo 'false';} ?>}" itemprop="articleBody">
    <button @click="faq=!faq" class="flex items-center justify-between w-full p-4">
        <span class="font-semibold text-xl text-gray-900 dark:text-white"><?php echo $year; $index++; ?>年</span>

        <span class="text-white bg-black/20 dark:bg-white/20 rounded-full" x-show="faq">
            <svg xmlns="http://www.w3.org/2000/svg" class="size-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18 12H6" />
            </svg>
        </span>
        <span class="text-white bg-[var(--primary)] rounded-full" x-show="!faq">
            <svg xmlns="http://www.w3.org/2000/svg" class="size-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
            </svg>
        </span>
    </button>

    <hr class="border-gray-200 dark:border-gray-500" x-show="faq">

    <div class="transition-all p-4 text-base space-y-2" :class="{'max-h-0 py-0 px-5 overflow-y-hidden':!faq,'p-4':faq}">
             <?php foreach($posts as $created => $post ): ?>
             <div class="flex justify-between items-center">
                       <div class="ml-5 flex items-center"><span class="bg-[var(--primary)] size-2 rounded-full mr-2"></span><a class="line-clamp-1" href="<?php echo $post['permalink']; ?>" ><?php echo $post['title']; ?></a>
                        </div>
                <div class="text-sm hidden sm:block"><?php echo date('m月d日',$created); ?></div>
            </div>
<?php endforeach; ?>
      </div>
</div>

<?php endforeach; ?>



<?php $this->need('footer.php'); ?>
