<?php
include 'common.php';

if ($user->hasLogin() || !$options->allowRegister) {
    $response->redirect($options->siteUrl);
}
$name = htmlspecialchars($_POST['name'] ?? '');
$mail = htmlspecialchars($_POST['mail'] ?? '');
$rememberName = $name;
$rememberMail = $mail;
\Typecho\Cookie::delete('__typecho_remember_name');
\Typecho\Cookie::delete('__typecho_remember_mail');

$bodyClass = 'body-100';

include 'header.php';
?>
<div class="typecho-login-wrap">
    <div class="typecho-login">
        <h1><a>『博客用户注册』</a></h1>
        <form action="<?php $options->registerAction(); ?>" method="post" name="register" role="form">
            <p>
                <label for="name" class="sr-only"><?php _e('用户名'); ?></label>
                <input type="text" id="name" name="name" placeholder="<?php _e('用户名'); ?>" value="<?php echo $rememberName; ?>" class="text-l w-100" autofocus />
            </p>
            <p>
                <label for="mail" class="sr-only"><?php _e('Email'); ?></label>
                <input type="email" id="mail" name="mail" placeholder="<?php _e('Email'); ?>" value="<?php echo $rememberMail; ?>" class="text-l w-100" />
            </p>
            <p class="submit">
                <button type="submit" class="btn btn-l w-100 primary"><?php _e('注册'); ?></button>
            </p>
        </form>
        
        <div class="more-link">
            <a href="<?php $options->siteUrl(); ?>"><?php _e('用户返回首页'); ?></a>
            &bull;
            <a href="<?php $options->adminUrl('login.php'); ?>"><?php _e('博客用户登录'); ?></a>
             <br>
            <span class="年份检测" id="yearSpan"></span> © 不见桃花不见秋 作
                        
            <br>本系统由<a href="https://lcy20.netlify.app/">归档-时光卷轴</a>站点提供支持，由开发者不见桃花不见秋二次修改提供，本系统源码包已纳入归档站点存放！
        </div>
    </div>
</div>
<?php
include 'common-js.php';
?>
<script>
// 获取当前年份并插入标签
document.getElementById("yearSpan").innerText = new Date().getFullYear();
</script>
<script>
$(document).ready(function () {
    $('#name').focus();
});
</script>
<?php
include 'footer.php';
?>
