<?php
// 设置允许大文件上传
ini_set('upload_max_filesize', '0');
ini_set('post_max_size', '0');
ini_set('max_execution_time', '0');
ini_set('max_input_time', '0');

// 上传目录
$uploadDir = 'wj/';

// 确保上传目录存在
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

$response = array('success' => false, 'message' => '');

// 检查是否有文件上传
if (!empty($_FILES['files'])) {
    $uploadedFiles = array();
    $errors = array();
    
    // 处理多个文件上传
    foreach ($_FILES['files']['name'] as $key => $name) {
        if ($_FILES['files']['error'][$key] === UPLOAD_ERR_OK) {
            $tmpName = $_FILES['files']['tmp_name'][$key];
            $fileName = basename($name);
            $filePath = $uploadDir . $fileName;
            
            // 防止文件名冲突
            $counter = 1;
            $originalName = $fileName;
            while (file_exists($filePath)) {
                $fileInfo = pathinfo($originalName);
                $fileName = $fileInfo['filename'] . '_' . $counter . '.' . $fileInfo['extension'];
                $filePath = $uploadDir . $fileName;
                $counter++;
            }
            
            // 移动上传的文件
            if (move_uploaded_file($tmpName, $filePath)) {
                $uploadedFiles[] = $fileName;
            } else {
                $errors[] = "文件 {$name} 上传失败";
            }
        } else {
            $errors[] = "文件 {$name} 上传错误: " . $_FILES['files']['error'][$key];
        }
    }
    
    if (empty($errors)) {
        $response['success'] = true;
        $response['message'] = '成功上传 ' . count($uploadedFiles) . ' 个文件';
    } else {
        $response['message'] = implode(', ', $errors);
    }
} else {
    $response['message'] = '没有文件被上传';
}

header('Content-Type: application/json');
echo json_encode($response);
?>
